---
title: FunASR API Usage Guide
slug: gKriAn53WLFxGYd6BwWvy
createdAt: Thu Jul 18 2024 06:17:27 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 06:42:25 GMT+0000 (Coordinated Universal Time)
---

# FunASR API Usage Guide

## Introduction

This document will guide developers on how to use the `aonweb` library to invoke the FunASR API, which is used for Automatic Speech Recognition (ASR).

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
    input: {
        "awv": "https://isv-data.oss-cn-hangzhou.aliyuncs.com/ics/MaaS/ASR/test_audio/vad_example.wav",
        "batch_size": 300
    }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/funasr", data, price);
    // Handle response
    console.log("Face swap result:", response);
} catch (error) {
    // Error handling
    console.error("Error performing face swap:", error);
}
```

### Parameter Description

- `awv`: String, specifies the URL of the audio file to be recognized.
- `batch_size`: Integer, specifies the batch size for processing the audio. This may affect processing speed and memory usage.

## Considerations

- Ensure the provided audio URL is publicly accessible and of good quality for optimal recognition results.
- The API may take some time to process the audio and generate results, especially for longer audio files. Consider implementing appropriate waiting or loading states.
- Handle potential errors, such as network issues, invalid input, or API limitations.
- Adhere to terms of use and privacy regulations, especially when processing audio containing sensitive information.

## Example Response

The API response will contain the recognized text content. Parse and use the response data according to the actual API documentation.


By following this guide, you should be able to effectively use the FunASR API for automatic speech recognition in your applications. If you have any questions or need further clarification, feel free to ask.

